#
#   *************************************
#   **   NUANCE - PICO-BELLO ISSUE 2   **
#   *************************************
#    a Chiptune Music-Disc on the RG-350
#                Nuance 2020
#
#  Credits:
#  Code: Andy/Nuance
#  Graphics: Raven/Nuance
#  Music: Chromag/Rebels&Genesis Project,
#  Teo/Focus Design&Rebels,O3eanos/Nuance,
#  Saga Musix/Nuance & ko0x, Andy/Nuance
#

import pygame
import time

# inits
pygame.mixer.pre_init(44100, -16, 2, 512)
pygame.mixer.init()
pygame.init()

screen = pygame.display.set_mode((320, 240))

back = pygame.image.load("wild_at_heart.png")
back2 = pygame.image.load("wild_at_heart2.png")
intro_back1 = pygame.image.load("nce_hand2.png")
intro_back2 = pygame.image.load("cubey_final.png")
presents = pygame.image.load("presents.png")
menu = pygame.image.load("menu.png")

pygame.mixer.music.load("intro.ogg")
pygame.mixer.music.play(-1)

cursorImg = pygame.image.load("cursor.png")

cursorX = 13
cursorY = 101
cursorX_change = 0
cursorY_change = 0

font = pygame.font.Font('freesansbold.ttf',12)

frame = pygame.time.Clock()
frame.tick(30)

# functions
def cursor(x, y):
    screen.blit(cursorImg, (x, y))

lineX = -1
scrollX = 325
scrollY = 220
movingUp = True
def scroller():
    global lineX, scrollX, scrollY, movingUp
    if lineX <= 380:
        lineX = lineX + 5
    pygame.draw.rect(screen, (0,0,0),[-1, 210, lineX, 0], 1)
    scrolltext01 = font.render("Welcome to the second issue of Pico-Bello, a chip-musicdisc series on different platforms. This second issue is optimized for the Anbernic RG350 handheld, but also runs on similar devices. Credits: Code: Andy/Nuance, Graphics: Raven/Nuance, Music: Chromag/Rebels & Genesis Project, Teo/Focus Design & Rebels, Ok3anos/Nuance, Saga Musix/Nuance & ko0x, Andy/Nuance... Greetings to the whole Nuance-bunch, everybody at online Novoque 2020 and to all our scene-friends... Hope to meet you all in person again soon!               .o0o. Hi there! Raven/Nuance on the keys. Oh my... thats a long time since I last was typing a scrolltext. Feels quite good though. Some infos on the fast graphics done for this music disc: The NUANCE-logo was done on the PC quite some time ago in Photoshop and just resized and slightly changed concerning colors. The karate guy with his heart is a really old pixel graphic originally done on the AAAAMIIIIGAAAAA in 640x256 (Amiga HiRes) and resized for this tiny musicdisc and then the small logo was added in Affinity Photo. And before anyone is crying again: Yes! I had a reference for the karate guy back in the old days. Deal with it. :D Also this was a rather fast gfx session at night, when Andy was showing me what he already has done and that kind of motivated me to sit there for some more time and contribute something. What a great feeling. Almost like in the good old days. :D Well. Thats it for now from my side. Take care everyone during these strange covid times and I really hope to see everyone of you soon at a demoparty again. Good night! Raven signing off .o0o.              ...Heido-ho, Andy back on the keyz ;-) Hope you enjoy the tracks so far. Thanks to all musicians who contributed a tune. Some of the tracks were made on the Amiga, one on the PICO-8, and others on the PC (but in a chiptune-style of course). Lets see on which platform the third issue of Pico-Bello will be released... still not sure about it ;-) Let's restart this scroller, so you don't have to read anymore but just listen :-) All the best for you, take care my friends, greetings...               Welcome to the second issue of Pico-Bello, a chip-musicdisc series on different platforms. This second issue is optimized for the Anbernic RG350 handheld, but also runs on similar devices. Credits: Code: Andy/Nuance, Graphics: Raven/Nuance, Music: Chromag/Rebels & Genesis Project, Teo/Focus Design & Rebels, Ok3anos/Nuance, Saga Musix/Nuance & ko0x, Andy/Nuance... Greetings to the whole Nuance-bunch, everybody at online Novoque 2020 and to all our scene-friends... Hope to meet you all in person again soon!               ", True,(80,80,80))
    screen.blit(scrolltext01,(scrollX, scrollY))
    scrollX = scrollX - 1.4
    if scrollY <= 215:
        movingUp = False
    elif scrollY >= 225:
        movingUp = True
    if movingUp == True:
        scrollY = scrollY - 0.65
    else:
        scrollY = scrollY + 0.65

def current_track():
    if current_song == 1:
        pygame.draw.rect(screen, (255,255,255),[0, 80, 150, 200], 0)
        pygame.draw.rect(screen, (235,235,235),[30, 102, 115, 17], 0)
    if current_song == 2:
        pygame.draw.rect(screen, (255,255,255),[0, 80, 150, 200], 0)
        pygame.draw.rect(screen, (235,235,235),[30, 120, 115, 17], 0)
    if current_song == 3:
        pygame.draw.rect(screen, (255,255,255),[0, 80, 150, 200], 0)
        pygame.draw.rect(screen, (235,235,235),[30, 138, 115, 17], 0)
    if current_song == 4:
        pygame.draw.rect(screen, (255,255,255),[0, 80, 150, 200], 0)
        pygame.draw.rect(screen, (235,235,235),[30, 156, 115, 17], 0)
    if current_song == 5:
        pygame.draw.rect(screen, (255,255,255),[0, 80, 150, 200], 0)
        pygame.draw.rect(screen, (235,235,235),[30, 174, 115, 17], 0)

# intro

alpha = 0
rectX1 = 270
intro1_count = 0
while intro1_count < 410:
    intro1_count = intro1_count + 1
    screen.blit(intro_back1,(0,0))
    if rectX1 >= 0:
        rectX1 = rectX1 - 0.8
    pygame.draw.rect(screen, (255,255,255),[0, 0, rectX1, 240], 0)
    if intro1_count > 320:
        if alpha <= 255:
            alpha = alpha + 3
        intro_back2.set_alpha(alpha)
        screen.blit(intro_back2,(0,0))
    pygame.display.flip()
    frame.tick(30)

alpha2 = 0
intro2_count = 0
while intro2_count < 230:
    intro2_count = intro2_count + 1
    if intro2_count <= 140:
        screen.blit(intro_back2,(0,0))
    if intro2_count > 140 and intro2_count <= 170:
        screen.blit(intro_back2,(0,0))
        screen.blit(presents,(190,200))
    if intro2_count > 170:
        screen.blit(intro_back2,(0,0))
        screen.blit(presents,(190,200))
        if alpha2 <= 255:
            alpha2 = alpha2 + 5
        back.set_alpha(alpha2)
        screen.blit(back,(0,0))
    pygame.display.flip()
    frame.tick(30)

# main-loop
current_song = 1
rectX2 = 150
running = True
while running == True:

    screen.blit(back, (0, 0))
    current_track()
    screen.blit(menu, (32,87))
    cursor(cursorX,cursorY)
    if rectX2 >= -3:
        rectX2 = rectX2 - 2.5
    pygame.draw.rect(screen, (255,255,255),[0, 80, rectX2, 200], 0)
    
    for event in pygame.event.get():
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE:
                running = False
                quit()
            if event.key == pygame.K_UP and cursorY >= 116:
                cursorY = cursorY - 18
            if event.key == pygame.K_DOWN and cursorY < 170:
                cursorY = cursorY + 18
            if event.key == pygame.K_SPACE and cursorY == 101:
                pygame.mixer.music.load("intro.ogg")
                pygame.mixer.music.play(-1)
                current_song = 1
            if event.key == pygame.K_SPACE and cursorY == 119:
                pygame.mixer.music.load("prophecy.ogg")
                pygame.mixer.music.play(-1)
                current_song = 2
            if event.key == pygame.K_SPACE and cursorY == 137:
                pygame.mixer.music.load("one_night_melody.ogg")
                pygame.mixer.music.play(-1)
                current_song = 3
            if event.key == pygame.K_SPACE and cursorY == 155:
                pygame.mixer.music.load("summer.ogg")
                pygame.mixer.music.play(-1)
                current_song = 4
            if event.key == pygame.K_SPACE and cursorY == 173:
                pygame.mixer.music.load("candy.ogg")
                pygame.mixer.music.play(-1)
                current_song = 5

    scroller()
    screen.blit(back2, (0, 209))
    pygame.display.flip()
    frame.tick(30)
